-- jeli tabela o takiej nazwie ju istnieje to j usu
IF OBJECT_ID (N'dbo.PRODUCT_HIER') IS NOT NULL
   DROP TABLE dbo.PRODUCT_HIER
GO
-- utwrz tabel PRODUCT_HIER
CREATE TABLE PRODUCT_HIER
( 
    MEM_ID		INT, 
    MEM_LEVEL		INT, 
    MEM_PID		INT
) 
GO



-- wyczy zawarto tabeli PRODUCT_HIER
TRUNCATE TABLE PRODUCT_HIER

--zadeklaruj zmienne pomocnicze
DECLARE @MAX_LEVEL INT, @POM1 INT, @POM2 INT

-- wywouj funkcj GetProductMembersRecHier2 z parametrem 1
-- w ten sposb wychodzimy do elementu nadrzedngo dla wszystkich innych
-- Do zmiennej @MAX_LEVEL przypisz maksymaln warto z kolumny MEM_LEVEL 
-- (ilo poziomw wymiaru PRODUCT)
SELECT @MAX_LEVEL = MAX(MEM_LEVEL) FROM GetProductMembersRecHier2(1)

-- dla zmiennych pomocniczych przyspiuje wartoci 
-- odpowiednio o 1 i o 2 mniejsze  wykorzystamy to w dalszej czci rozwizania
SET @POM1 = @MAX_LEVEL - 1
SET @POM2 = @MAX_LEVEL - 2

-- wstaw do tabeli PRODUCT_HIER informacje o elementach liciach i ssiadujcych z nimi 
-- bezporednio rodzicami  na wszystkich poziomach hierarchii
WHILE @POM1 <> 0
BEGIN
	INSERT INTO PRODUCT_HIER
	SELECT A.MEM_ID, @POM1, B.MEM_ID
-- LEFT OUTER JOIN spowoduje, e w rekordach, w ktrych nie ma bezporedniej relacji
-- wstawiona zostanie warto NULL w kolumnie MEM_PID
	FROM GetProductMembersRecHier2(1) A LEFT OUTER JOIN GetProductMembersRecHier2(1) B		ON A.MEM_PID = B.MEM_ID AND B.MEM_LEVEL = @POM1
	WHERE A.MEM_LEVEL = @MAX_LEVEL

	SET @POM1 = @POM1 - 1
END
-- tam gdzie wystpuje warto NULL aktualizuj kolumn MEM_PID odpowiednimi wartociami 
WHILE @POM2 <> 0
BEGIN

	UPDATE PRODUCT_HIER
	SET MEM_PID = 
	(
		SELECT B.MEM_ID
		FROM PRODUCT_PC AS B
		WHERE B.MEM_ID=(
					SELECT C.MEM_PID 
					FROM PRODUCT_PC C 
					WHERE C.MEM_ID =(
								SELECT DISTINCT D.MEM_PID 
								FROM PRODUCT_HIER D
								WHERE D.MEM_LEVEL = @POM2+1 AND D.MEM_ID=A.MEM_ID
								)
					)
	)

	FROM PRODUCT_HIER A
	WHERE A.MEM_PID IS NULL AND A.MEM_LEVEL=@POM2

	SET @POM2 = @POM2 - 1
END

-- przygotuj wyniki w postaci tabeli Multilevel
-- podzapytania pobieraj nazwy elementw z poszczeglnych poziomw
SELECT 
	[1] as L1_ID,
	(SELECT MEM_NAME FROM PRODUCT_PC WHERE MEM_ID = [1]) AS L1_NAME,
	[2] as L2_ID,
	(SELECT MEM_NAME FROM PRODUCT_PC WHERE MEM_ID = [2]) AS L2_NAME,
	[3] as L3_ID,
	(SELECT MEM_NAME FROM PRODUCT_PC WHERE MEM_ID = [3]) AS L3_NAME,
	[4] as L4_ID,
	(SELECT MEM_NAME FROM PRODUCT_PC WHERE MEM_ID = [4]) AS L4_NAME,
	P.MEM_ID AS L5_ID,
	(SELECT T.MEM_NAME FROM PRODUCT_PC T WHERE T.MEM_ID = P.[MEM_ID]) AS L5_NAME
FROM 
    (SELECT MEM_ID, MEM_LEVEL, MEM_PID
        FROM PRODUCT_HIER) s 
PIVOT 
( 
    SUM([MEM_PID])
    FOR MEM_LEVEL IN ([4],[3],[2],[1]) 
) P 
ORDER BY L5_NAME 
GO 
